/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.editor.php.internal.builder.FileSystemModule;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public final class PHPFileSystemModuleFactory {
    private static final String COMPILED_SMARTY_REGEX = "(%%).+(%%).+";
    private static final String COMPILED_SMARTY_PREFIX = "%%";
    private static final String PHP_SOURCE_CONTENT_TYPE = "com.aptana.contenttype.phtml.php";
    private static IContentType contentType = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.phtml.php");

    static {
        Platform.getContentTypeManager().addContentTypeChangeListener(new IContentTypeManager.IContentTypeChangeListener(){

            public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
                if (PHPFileSystemModuleFactory.PHP_SOURCE_CONTENT_TYPE.equals(event.getContentType().getId())) {
                    contentType = Platform.getContentTypeManager().getContentType(PHPFileSystemModuleFactory.PHP_SOURCE_CONTENT_TYPE);
                }
            }
        });
    }

    public static IModule getModule(File resource, IBuildPath buildPath) {
        String name;
        if (resource.exists() && resource.isFile() && contentType.isAssociatedWith(name = resource.getName())) {
            if (name.startsWith(COMPILED_SMARTY_PREFIX) && name.matches(COMPILED_SMARTY_REGEX)) {
                return null;
            }
            return new FileSystemModule(resource, buildPath, false);
        }
        return null;
    }

    private PHPFileSystemModuleFactory() {
    }
}

